##################################################################
# R code: Exercise 11.6(c) 
# File: myDM-VmyDM.r
# Coded by: Dao Li
#
# Testing equal forecast accuracy.
#
# INPUT: h
# Benchmark (N = nonlinear, L = linear): 
# d = (eN[1,]^2-eL[1,]^2), Y_{1,t} from VAR
# d = (eN[2,]^2-eL[2,]^2), Y_{2,t} from VAR
##################################################################
myDM <- function (d, h, templag=NULL) 
{
#d <- c(abs(e1))^power - c(abs(e2))^power
d.cov <- acf(d,na.action=na.omit,lag.max=templag,type="covariance", 
       plot=FALSE)$acf[, , 1]
d.var <- sum(c(d.cov[1], 2 * d.cov[-1]))/length(d)
STATISTIC <- mean(d, na.rm = TRUE)/sqrt(d.var)
return(STATISTIC) # normal
}
################################################################### 
# R code: Exercise 11.6(c)
# File: myDM-VmyDM.r
# Coded by: Dao Li
#
# Testing equal forecast accuracy in terms of "d" instead of 
# "e1" and "e2".
#
# INPUT: 
#  h = forecast horizon; Benchmark (N=nonlinear, L=linear): 
#  d = cbind(eN[1,]^2-eL[1,]^2,eN[2,]^2-eL[2,]^2), Y_{i,t} from VAR
###################################################################
VmyDM <- function (d,h,templag=NULL) 
{
#d <- c(abs(e1))^power - c(abs(e2))^power
d.cov<-acf(d,na.action = na.omit,lag.max=templag,type="covariance",
       plot=FALSE)$acf
n <- length(d[1,])
temp1 <- NULL
k <- 1
while(k <= n){
   temp1 <- rbind(temp1,d.cov[1,1:n,k])
   k <- k + 1
   }
temp2 <- temp1
if(h >= 2){
for(j in 2:length(d.cov[,1,1]))
  {
  temp1 <- NULL
  k     <- 1
  while(k <= n){
     temp1 <- rbind(temp1,d.cov[j,1:n,k])
     k     <- k + 1
     }
  temp2 <- temp2+temp1+t(temp1)
  }
}
